import { connect } from 'react-redux'

import { Project } from '@agiliza/api/domain/project'
import { StoreState } from '@agiliza/redux'

export interface ConnectedProps {
  fetching: boolean
  proposals: Project[]
}

type StateProps = Pick<ConnectedProps, 'fetching' | 'proposals'>
// type DispatchProps = Pick<ConnectedProps, 'getContext'>

const mapStateToProps = (state: StoreState): StateProps => ({
  fetching: false,
  proposals: [],
})

// const mapDispatchToProps = (dispatch: Dispatch): DispatchProps =>
//   bindActionCreators(
//     {
//     },
//     dispatch
//   )

export const connected = connect(mapStateToProps)
