import cn from 'classnames'
import React from 'react'

import { browser, SUPPORTED_BROWSERS } from '@agiliza/constants/browser'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {}

const chrome = SUPPORTED_BROWSERS['chrome'].replace(/(>=)/g, '') + '+'
const firefox = SUPPORTED_BROWSERS['firefox'].replace(/(>=)/g, '') + '+'
const edge = SUPPORTED_BROWSERS['windows']['edge'].replace(/(>=)/g, '') + '+'
const safari = SUPPORTED_BROWSERS['macos']['safari'].replace(/(>=)/g, '') + '+'

const BrowserIncompatible = (props: Props) => {
  const { classes } = props
  return (
    <div className={classes.page}>
      <i className={cn('fas fa-exclamation-circle', classes.titleIcon)} />
      <h1 className={classes.title}>Navegador não suportado</h1>
      <p className={classes.subTitle}>{`Você está usando o ${browser.getBrowserName()} na versão ${browser.getBrowserVersion()}`}</p>
      <p className={classes.subTitle}>É recomendado utilizar o {process.env.APP_TITLE} em um dos seguintes navegadores:</p>
      <div className={classes.browserList}>
        <a target="#" className={classes.anchorBrowser} href="https://www.google.com/chrome/">
          <i className={cn('fab fa-chrome', classes.icon)} />
          Chrome {chrome}
        </a>
        <a target="#" className={classes.anchorBrowser} href="https://www.mozilla.org/en-US/firefox/new/">
          <i className={cn('fab fa-firefox-browser', classes.icon)} />
          Firefox {firefox}
        </a>
        <a target="#" className={classes.anchorBrowser} href="https://www.microsoft.com/en-us/edge">
          <i className={cn('fab fa-edge', classes.icon)}></i>
          Edge {edge}
        </a>
        <a target="#" className={classes.anchorBrowser} href="https://support.apple.com/downloads/safari">
          <i className={cn('fab fa-safari', classes.icon)}></i>
          Safari {safari}
        </a>
      </div>
    </div>
  )
}

export default withStyles(styles)(BrowserIncompatible)
