import red from '@material-ui/core/colors/red'
import { createMuiTheme } from '@material-ui/core/styles'

export const defaultToobarHeight = 64

export const theme = createMuiTheme({
  palette: {
    primary: {
      light: '#034da6',
      main: '#0d3366'
    },
    secondary: {
      main: '#23a897',
      contrastText: '#fafafa'
    },
    text: { primary: '#2e2e2e' },
    error: {
      main: red[500]
    }
  },
  mixins: {
    toolbar: {
      minHeight: defaultToobarHeight
    }
  },
  typography: {
    fontSize: 13,
    fontFamily: "'Rubik', 'Roboto', 'Open Sans', sans-serif"
  },
  overrides: {
    MuiInputBase: {
      input: {
        '&:-webkit-autofill': {
          WebkitBoxShadow: '0 0 0 1000px white inset'
        }
      }
    },
    MuiTableCell: {
      root: {
        fontFamily: 'Heebo'
      }
    },
    MuiListItemText: {
      primary: {
        fontFamily: 'Heebo'
      }
    },
    MuiDialogContentText: {
      root: {
        fontFamily: 'Heebo'
      }
    },
    MuiListItemIcon: {
      root: {
        minWidth: 40
      }
    }
  }
})
