import { SystemData } from '@agiliza/redux/entities/system'
import { createSlice, PayloadAction } from '@reduxjs/toolkit'

export interface State {
  fetching: boolean
}

export const initialState: State = {
  fetching: false,
}

const slice = createSlice({
  name: 'ui/system',
  initialState,
  reducers: {
    fetchMenu(state) {
      state.fetching = true
    },
    fetchMenuSuccess(state, action: PayloadAction<SystemData>) {
      state.fetching = false
    },
    fetchMenuError(state, action: PayloadAction<string>) {
      state.fetching = false
    },
  },
})

export default slice
