import { createSlice, PayloadAction } from '@reduxjs/toolkit'

const prefix = 'ui/simulation'

export interface State {
  data?: { simulationCategoryId: string; amount: string; paymentMonths: number; graceMonths: number }
}

export const initialState: State = {}

const simulation = createSlice({
  name: prefix,
  initialState,
  reducers: {
    setData: (state, action: PayloadAction<State['data']>) => {
      state.data = action.payload
    },
  },
})

export default simulation
