import {
  initialState as drawerInitialState,
  reducer as drawer,
  State as DrawerState
} from './drawer'
import { initialState as errorInitialState, reducer as error, State as ErrorState } from './error'
import login, { initialState as loginInitialState, State as LoginState } from './login'
import simulation, {
  initialState as simulationInitialState,
  State as SimulationState
} from './simulation'
import {
  initialState as systemInitialState,
  reducer as system,
  State as SystemState
} from './system'

export interface UIState {
  login: LoginState
  error: ErrorState
  drawer: DrawerState
  simulation: SimulationState
  system: SystemState
}

const reducers = {
  login,
  error,
  drawer,
  system,
  simulation,
}

export const initialState: UIState = {
  login: loginInitialState,
  error: errorInitialState,
  drawer: drawerInitialState,
  system: systemInitialState,
  simulation: simulationInitialState,
}

export default reducers
