import { createSlice, PayloadAction } from '@reduxjs/toolkit'

export interface State {
  error: string
}

export const initialState: State = {
  error: ''
}

const employee = createSlice({
  name: 'ui/error',
  initialState,
  reducers: {
    setErrorMessage: (state, action: PayloadAction<string>) => {
      state.error = action.payload
    }
  }
})

export default employee
