import {
  AddBDProductService,
  AddCDReference,
  AddCDVehicle,
  BDProductService,
  GetBDProductsServices,
  GetCDReferences,
  GetCDVehicles,
  Identification,
  Reference,
  UpdateBDProductService,
  UpdateCDReference,
  UpdateCDVehicle,
  Vehicle
} from '@agiliza/api/domain'
import { types as businessDataTypes } from '@agiliza/redux/useCases/proposalData/businessData'
import { types as customerDataTypes } from '@agiliza/redux/useCases/proposalData/customerData'
import { createSlice, PayloadAction } from '@reduxjs/toolkit'

import { PROPOSAL_DATA_PREFIX } from '../shared'

export interface Store {
  proposalId: string
  personId: string
  references: Reference[]
  vehicles: Vehicle[]
  productsServices: BDProductService[]
}

export const initialState: Store = {
  proposalId: '',
  personId: '',
  references: [],
  vehicles: [],
  productsServices: [],
}

export default createSlice({
  name: `${PROPOSAL_DATA_PREFIX}/proposal`,
  initialState,
  reducers: {},
  extraReducers: {
    [customerDataTypes.createProposal.fulfilled]: (state, action: PayloadAction<string>) => {
      state.proposalId = action.payload
    },
    [customerDataTypes.addIndentification.fulfilled]: (state, action: PayloadAction<Identification>) => {
      console.log(action)
      state.personId = action.payload.id
    },
    [customerDataTypes.getReferences.fulfilled]: (state, action: PayloadAction<GetCDReferences['Output']>) => {
      state.references = action.payload
    },
    [customerDataTypes.addReference.fulfilled]: (state, action: PayloadAction<AddCDReference['Output']>) => {
      state.references = action.payload
    },
    [customerDataTypes.updateReference.fulfilled]: (state, action: PayloadAction<UpdateCDReference['Output']>) => {
      state.references = action.payload
    },
    [customerDataTypes.getVehicles.fulfilled]: (state, action: PayloadAction<GetCDVehicles['Output']>) => {
      state.vehicles = action.payload
    },
    [customerDataTypes.addVehicle.fulfilled]: (state, action: PayloadAction<AddCDVehicle['Output']>) => {
      state.vehicles = action.payload
    },
    [customerDataTypes.updateVehicle.fulfilled]: (state, action: PayloadAction<UpdateCDVehicle['Output']>) => {
      state.vehicles = action.payload
    },
    [businessDataTypes.getProductsServices.fulfilled]: (state, action: PayloadAction<GetBDProductsServices['Output']>) => {
      state.productsServices = action.payload
    },
    [businessDataTypes.addProductService.fulfilled]: (state, action: PayloadAction<AddBDProductService['Output']>) => {
      state.productsServices = action.payload
    },
    [businessDataTypes.updateProductService.fulfilled]: (state, action: PayloadAction<UpdateBDProductService['Output']>) => {
      state.productsServices = action.payload
    },
  },
})
