import { Entity } from '@agiliza/utils/method'

export * from './proposalData'
export * from './context'
export * from './error'
export * from './simulation'
export * from './authentication'

export interface Customer {
  name: string
  email: string
  ownerName?: string
  ownerCPF?: string
  cpfcnpj: string
  phone: string
  avatarUrl?: string
  address?: Partial<Address>
  profilePicture?: string
}

export interface IdDescricao {
  id: string
  descricao: string
}

export interface CodigoDescricao {
  codigo: string
  descricao: string
}

export interface DocumentType extends Entity {
  description: string
}

export interface Document {
  id: string
  type: DocumentType
  extraInformations: string
  url: string
}
