import { Theme } from '@material-ui/core'
import { createStyles } from '@material-ui/core/styles'

// import sharedStyles from '../../shared-styles'

export default (theme: Theme) => {
  const display = 'flex'
  return createStyles({
    pageContent: {
      height: `calc(100vh - ${theme.mixins.toolbar.minHeight}px)`,
      padding: theme.spacing(2),
      display: 'flex',
      flexDirection: 'column',
      overflowY: 'hidden',
    },
    title: {
      flexGrow: 1,
      fontSize: '100%',
    },
    circularProgressContainer: {
      display: 'flex',
      width: '100%',
      height: '100%',
      flex: 1,
      alignItems: 'center',
      justifyContent: 'center',
    },
    circularProgress: { position: 'absolute', top: '50%', left: '50%' },
    container: { display: 'flex', flexDirection: 'column', flex: 1, height: '100%' },
    inputContainer: { display, flexWrap: 'wrap' },
    form: { display, flexWrap: 'wrap', alignItems: 'center' },
    formContent: {
      marginRight: theme.spacing(3),
      flexWrap: 'wrap',
      display,
      flexDirection: 'column',
      width: '85%',
    },
  })
}
