import { connect } from 'react-redux'
import { bindActionCreators, Dispatch } from 'redux'

import { StoreState } from '@agiliza/redux'
import { actions as drawerActions } from '@agiliza/redux/ui/drawer'
import { isDrawerOpen } from '@agiliza/redux/ui/drawer/selectors'
import { actions as loginActions } from '@agiliza/redux/ui/login'

export interface ConnectedProps {
  drawerOpen: boolean
  toggleDrawer: typeof drawerActions.toggleDrawer
  logout: typeof loginActions.logout
}

type StateProps = Pick<ConnectedProps, 'drawerOpen'>
type DispatchProps = Pick<ConnectedProps, 'logout' | 'toggleDrawer'>

const mapStateToProps = (state: StoreState): StateProps => ({
  drawerOpen: isDrawerOpen(state.ui.drawer),
})

const mapDispatchToProps = (dispatch: Dispatch): DispatchProps =>
  bindActionCreators(
    {
      toggleDrawer: drawerActions.toggleDrawer,
      logout: loginActions.logout,
    },
    dispatch
  )

export default connect(mapStateToProps, mapDispatchToProps)
