import { drawerWidth } from '@agiliza/constants/styles'
import { createStyles, Theme } from '@material-ui/core/styles'

export const styles = (theme: Theme) => {
  return createStyles({
    selected: {
      backgroundColor: theme.palette.primary.light,
      color: theme.palette.primary.contrastText,
      borderRadius: 40,
      '& .MuiTypography-root': {
        fontWeight: 'bold',
      },
      '& .MuiListItemIcon-root': {
        color: theme.palette.primary.contrastText,
      },
      '&:hover': {
        backgroundColor: theme.palette.primary.main,
      },
    },
    list: {
      flex: 1,
      flexDirection: 'column',
      display: 'flex',
      paddingLeft: theme.spacing(1),
      paddingRight: theme.spacing(1),
      '& .MuiListItem-button:not(:last-of-type)': {
        marginBottom: theme.spacing(1),
      },
      '& .MuiListItem-button': {
        borderRadius: 40,
      },
    },
    listItem: {
      overflowX: 'hidden',
      width: drawerWidth,
      paddingLeft: theme.spacing(1.5),
    },
    grow: { flex: 1 },
  })
}
