import { extractNumbers } from './method'

export const maskCPFCNPJ = (str?: string) => {
  if (!str) return ''
  const filteredString = extractNumbers(str)
  // if (filteredString.length !== str.length) return str

  const length = filteredString.length
  if (length < 4) return filteredString
  if (length < 7) return filteredString.replace(/(\d\d\d)/, '$1.')
  if (length < 10) return filteredString.replace(/(\d\d\d)(\d\d\d)/, '$1.$2.')
  if (length < 12) {
    return filteredString.replace(/(\d\d\d)(\d\d\d)(\d\d\d)/, '$1.$2.$3-')
  }

  if (length < 13) {
    return filteredString.replace(/(\d\d)(\d\d\d)(\d\d\d)(\d\d\d\d)/, '$1.$2.$3/$4')
  }
  if (length < 15) {
    return filteredString.replace(/(\d\d)(\d\d\d)(\d\d\d)(\d\d\d\d)/, '$1.$2.$3/$4-')
  }

  return filteredString
}

export const maskCNPJ = (text: string) => {
  if (!text) return ''
  const filteredText = extractNumbers(text)
  const length = filteredText.length
  if (length < 3) return filteredText
  if (length < 6) return filteredText.replace(/(\d\d)/, '$1.')
  if (length < 9) return filteredText.replace(/(\d\d)(\d\d\d)/, '$1.$2.')
  if (length < 13) return filteredText.replace(/(\d\d)(\d\d\d)(\d\d\d)/, '$1.$2.$3/')
  if (length < 15) return filteredText.replace(/(\d\d)(\d\d\d)(\d\d\d)(\d\d\d\d)/, '$1.$2.$3/$4-')

  return text
}

export const maskCEP = (str?: string) => {
  if (!str) return ''
  const filteredString = extractNumbers(str)
  // if (filteredString.length !== str.length) return str

  const length = filteredString.length
  if (length < 6) return filteredString
  if (length < 9) return filteredString.replace(/(\d\d\d\d\d)/, '$1-')
  return filteredString
}

export const maskTel = (str?: string) => {
  if (!str) return ''
  let filteredString = extractNumbers(str)
  // if (filteredString.length !== str.length) return str
  if (filteredString[0] === '0') filteredString = filteredString.substring(1)
  const length = filteredString.length
  if (length < 3) return filteredString
  if (length < 7) return filteredString.replace(/(\d\d)/, '($1) ')
  if (length < 11) return filteredString.replace(/(\d\d)(\d\d\d\d)/, '($1) $2-')
  if (length < 12) {
    return filteredString.replace(/(\d\d)(\d\d\d\d\d)/, '($1) $2-')
  }

  return filteredString
}

export const maskPhone = (str?: string) => {
  if (!str) return ''
  const filteredString = extractNumbers(str)
  const length = filteredString.length
  if (length < 3) return filteredString
  if (length < 8) return filteredString.replace(/(\d\d)/, '($1) ')
  // if (length < 12) return filteredString.replace(/(\d\d)(\d\d\d\d\d)/, '($1) $2-')
  return filteredString.replace(/(\d\d)(\d\d\d\d\d)/, '($1) $2-')

  // return filteredString
}

export const maskLandline = (str?: string) => {
  if (!str) return ''
  const filteredString = extractNumbers(str)
  const length = filteredString.length
  if (length < 3) return filteredString
  if (length < 8) return filteredString.replace(/(\d\d)/, '($1) ')
  // if (length < 12) return filteredString.replace(/(\d\d)(\d\d\d\d\d)/, '($1) $2-')
  return filteredString.replace(/(\d{2})(\d{4})/, '($1) $2-')

  // return filteredString
}

export const maskRG = (txt?: string) => {
  if (!txt) return ''

  const filteredTxt = extractNumbers(txt)
  if (filteredTxt.length < 2) return filteredTxt
  if (filteredTxt.length < 5) return filteredTxt.replace(/^(\d)/g, '$1.')
  if (filteredTxt.length < 8) return filteredTxt.replace(/^(\d)(\d{3})/g, '$1.$2.')

  return txt
}

export const maskLicensePlate = (str?: string) => {
  if (!str) return ''
  const filteredString = str.toUpperCase().replace(/([^A-Z0-9]*)/g, '')
  const length = filteredString.length
  if (length < 4) return filteredString
  if (length < 8) return filteredString.replace(/(\w{3})/, '$1-')
  // if (length < 8) return filteredString.replace(/(\w{3})(\d{4})/g, '$1-$2')

  return filteredString
}

export const maskMonthYear = (text: string) => {
  if (!text) return ''
  const filteredTxt = extractNumbers(text)
  if (filteredTxt.length < 2) return filteredTxt
  return filteredTxt.replace(/^(\d{2})/g, '$1/')
}
