import { createSelector } from 'reselect'

import { Project, ProjectContext } from '@agiliza/api/domain'
import { entries, values } from '@agiliza/utils/method'

import { Store } from './slice'

export const getAllIds = (key: keyof Store) => (state: Store) => {
  return state[key].allIds
}

export const getById = (key: keyof Store) => (state: Store) => {
  return state[key].byId
}

export const getContext = (state: Store) =>
  entries(state).reduce((entities, [k, v]) => {
    return { ...entities, [k]: values(v.byId) }
  }, {} as ProjectContext)

export const getProjects = createSelector(getById('projects'), getAllIds('projects'), (byId, allIds) => allIds.map((id) => byId[id] as Project))
