const config = await fetch('./config.json').then((res) => res.json())

const { API_URL, APP_NAME_CUSTOMER, SESSION_KEY_BROKER } = config

export { API_URL }
export const SESSION_KEY = SESSION_KEY_BROKER

export const APP_NAME = APP_NAME_CUSTOMER

export interface UserAgent {
  appVersion: string
  platform: {
    name: string
    version: string
  }
}

export function mapUserAgentToString(agent: UserAgent) {
  return `${APP_NAME}/${agent.appVersion} (${agent.platform.name}/${agent.platform.version})`
}
