import type { ApiError } from '@agiliza/api/domain'
import { ErrorTypes } from '@agiliza/constants/error'

import { ResponseErrorAdapter } from './error'

export class LoginErrorAdapter extends ResponseErrorAdapter {
  public mapApiModelToDomain = async (error: Response): Promise<ApiError> => {
    if (error instanceof Response) {
      if (error.status === 403) {
        // Unauthorized
        return {
          type: ErrorTypes.UNAUTHORIZED,
          message: 'As credenciais fornecidas não são válidas.',
        }
      }
    }
    return super.mapApiModelToDomain(error)
  }
}
