import { EstadoApiModel, MunicipioApiModel } from '@microcredito/client'

import { City, State } from '../../domain'
import { DomainAdapter } from './shared'

export class CityAdapter implements DomainAdapter<MunicipioApiModel, City> {
  public mapApiModelToDomain = (apimodel: MunicipioApiModel): City => {
    return {
      id: apimodel.codigo,
      name: apimodel.nome,
      state: apimodel.estado,
    }
  }
}

export class StateAdapter implements DomainAdapter<EstadoApiModel, State> {
  public mapApiModelToDomain = (apimodel: EstadoApiModel): State => {
    return {
      id: apimodel.codigo,
      name: apimodel.nome,
      acronym: apimodel.sigla,
    }
  }
}
