import { GetSubProducts } from '@agiliza/api/domain/simulation/simulation'
import { SimularCreditoRequestApiModel } from '@microcredito/client'

import { ApiAdapter } from '../shared'

export class GetSubProductsApiMapper implements ApiAdapter<GetSubProducts['Input'], SimularCreditoRequestApiModel> {
  public mapDomainToApiModel = (input: GetSubProducts['Input']): SimularCreditoRequestApiModel => ({
    valorCredito: input.creditValue,
    codigoCarencia: input.gracePeriodId,
    codigoModalidade: input.categoryId,
    numeroParcelas: input.installmentsNumber,
  })
}
