import { CreateCustomer } from '@agiliza/api/domain'
import { extractNumbers } from '@agiliza/utils/extractors'
import { CriarUsuarioPrimeiroAcessoRequest } from '@microcredito/client/dist/apis/ClienteApi'

import { ApiAdapter } from './shared'

export class CreateCustomerApiMapper implements ApiAdapter<CreateCustomer['Input'], CriarUsuarioPrimeiroAcessoRequest> {
  public mapDomainToApiModel = (input: CreateCustomer['Input']): CriarUsuarioPrimeiroAcessoRequest => ({
    criarUsuarioPrimeiroAcessoRequestApiModel: {
      usuario: {
        usuarioCliente: {
          cpfcnpj: extractNumbers(input.cpf),
          nome: input.name,
          email: input.email,
          celular: extractNumbers(input.phone),
          endereco: {
            cep: extractNumbers(input.cep),
            logradouro: input.street,
            numero: input.number,
            estado: input.state,
            municipio: input.city,
            complemento: input.complement,
            bairro: input.district,
          },
        },
      },
    },
  })
}
