interface Persistent {
  oid: number
}
export enum QuestionType {
  SUBJECTIVE,
  OBJECTIVE
}
export enum ExamQuestionStatus {
  ACTIVE,
  CANCELED
}
export enum ExamType {
  SUBJECTIVE_ONLY,
  OBJECTIVE_ONLY,
  MIXED
}
export enum ExamDeploymentStatus {}
export enum ExamDeploymentType {
  ONLINE,
  ON_SITE
}
export interface QuestionCategory extends Persistent {
  label: string
  questions: Question[] | number[]
}
export interface QuestionAlternative extends Persistent {
  order: number
  statement: string
}
export interface Question extends Persistent {
  type: QuestionType
  statement: string
  categories: QuestionCategory[] | number[]
}
export interface SubjectiveQuestion extends Question {
  answerKey: string
}
export interface ObjectiveQuestion extends Question {
  answerKey: QuestionAlternative | number
  alternatives: QuestionAlternative[] | number[]
}
export interface ExamQuestionGroup extends Persistent {
  label: string
  weight: number
}
export interface ExamQuestion extends Persistent {
  question: Question | number
  order: number
  weight: number
  status: ExamQuestionStatus
}
export interface Exam extends Persistent {
  cover: string
  date: string
  label: string
  questions: ExamQuestion[] | number[]
  groups: ExamQuestionGroup[] | number[]
  type: ExamType
}
export interface ExamDeployment extends Persistent {
  date: string
  status: ExamDeploymentStatus
  type: ExamDeploymentType
  exam: Exam | number
}
export interface OnlineExamDeployment extends ExamDeployment {
  enforceSequence: boolean
}
export interface OnSiteExamDeployment extends ExamDeployment {
  local: string
}
