# Processo de reaização de um assessment

* A aplicação deverá adquirir o `assessment` a ser realizado através da rota `/assessment/{assessmentId}`

 ```json
 {
    "enforceSequence": false,
    "locationType": 0,
    "oid": 0,
    "status": 0,
    "submitterType": 0,
    "type": 0,
    "schedule": {
        "startsAt": "date-time",
        "endsAt": "date-time"
    },
    "exam": {
        "type": 0,
        "label": "test",
        "cover": "<gateemeele>oi</gateemeele>",
        "groups": [
            {
                "label": "group 1",
                "weight": 0,
                "oid": 0
            }
        ],
        "questions": [
            {
                "oid": 0,
                "order": 0,
                "weight": 0,
                "group": 0,
                "status": 0,
                "question": 0
            }
        ]
    }
}
 ```

* Com o assessment em mãos, a aplicação é capaz de liberar o começo do exame, criando assim um `draft`, por um método POST na rota `assessments/{assessmentId}/drafts`.
 
 ```json
  {
      "oid": 0,
      "answers": [],
      "assessment": 0,
      "finishedAt": "date-time",
      "lastUpdate": "date-time",
      "startedAt": "date-time",
      "status": 0,
      "type": 0,
      "uploadUri": ""
  }
  ```
  
* Para exibir uma nova questão, a aplicação deverá buscar a mesma através da rota `/assessments/{assessmentId}/questions/{questionId}`
* Assim que uma questão for realizada, um novo POST na rota `assessments/{assessmentId}/drafts` deverá ser realizado passando a nova questão

  ```json
  {
    "oid": 0,
    "answers": [
        {
            "choice": 0,
            "freeText": "",
            "question": 0
        }
    ],
    "assessment": 0,
    "finishedAt": "date-time",
    "lastUpdate": "date-time",
    "startedAt": "date-time",
    "status": 0,
    "type": 0,
    "uploadUri": ""
  }
  ```
  
* Ao finalizar a prova o `draft` deve ser convertido em `submission` através do método POST na rota `/assessments/{assessmentId}/submissions`
